﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for HappyHourSelection.xaml
    /// </summary>
    public partial class HappyHourSelection : Window
    {
        static List<HappyHours> _happyHours;
        public HappyHourSelection()
        {
            InitializeComponent();
            LoadHappyHours();
        }
        private void LoadHappyHours()
        {
            _happyHours = HappyHourPromoBL.GetList(Guid.Empty);
            if (_happyHours != null && _happyHours.Count > 0)
            {
                _happyHours = _happyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
            }
            gvHapyHours.ItemsSource = _happyHours;
        }

        private void btnAddRow_Click(object sender, RoutedEventArgs e)
        {
            AddEditHappyHours _AddHappyHour = new AddEditHappyHours();
            _AddHappyHour.Owner = this;
            _AddHappyHour.ShowDialog();
            if (bool.Parse(_AddHappyHour.Tag.ToString()))
                LoadHappyHours();
        }

        private void btnRemoveRow_Click(object sender, RoutedEventArgs e)
        {

            if (gvHapyHours.SelectedItem != null)
            {
                if (App.ConfirmationDialog("Do you want to remove the happy hour promotion?", "Ei8ht POS"))
                {
                    HappyHours selectedItem = (HappyHours)gvHapyHours.SelectedItem;
                    HappyHourPromoBL.Delete(selectedItem.UniqueID);
                    gvHapyHours.ItemsSource = null;
                    _happyHours = HappyHourPromoBL.GetList(Guid.Empty);
                    if (_happyHours != null && _happyHours.Count > 0)
                    {
                        _happyHours = _happyHours.Where(a => a.IsEnabled).ToList<HappyHours>();
                    }
                    gvHapyHours.ItemsSource = _happyHours;
                }
            }
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

    }
}
